# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 3
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Rounds 2-5: Forgiving Tit-for-Tat
    elif 2 <= current_round <= 5:
        if opp_history[-1] == "C":
            return "D" if random.random() < 0.1 else "C"
        else:
            return "D" if random.random() < 0.8 else "C"
    
    # Rounds 6-8: Controlled Aggression
    elif 6 <= current_round <= 8:
        early_defects = opp_history[:5].count("D")
        if early_defects > 2:
            return "D"
        else:
            return "D" if current_round % 2 == 0 else "C"
    
    # Round 9: Defect unconditionally
    elif current_round == 9:
        return "D"
    
    # Round 10: Defect unconditionally
    elif current_round == 10:
        return "D"
    
    # Fallback (shouldn't happen in a 10-round match)
    return "D"